/*
 AdBlock X
 http://www.adblockx.com
 Description: Helps you examine ad-blockers' impact on your website and act accordingly
 Author: DDC Inc.
 Copyright (c) 2015-16 DDC Inc.
 */
(function() {
	var Abx = function() {
		var isNetworkBlocked = 0;
		var isBlockingNonIntrusiveAds = 0;
		var isBlockingIntrusiveAds = 0;

		var cookieExpiry = 256;  // 1 year
		var adBlockStatusCookieKey = 'abs';
		var pageViewsCookieKey = 'pv';
		var elapsedPageViewsCookieKey = 'pvfc';
		var visitedBeforeCookieKey = 'v';
		var pageViewsByDateCookieKey = 'urd';
		var reactionViewsCookieKey = 'rvc';

		var fireAblPixel = function (parameters) {
			if (!parameters) {
				return;
			}

			parameters += "&lc=0";
			parameters += "&unq=" + (isUniqueVisitor() ? 1 : 0);

			

			var pixelUrl = "https://www.muhammeddincer.com/wp-admin/admin-ajax.php";
			var searchSeparator = (pixelUrl.indexOf('?') == -1) ? '?' : '&';
			pixelUrl = pixelUrl + searchSeparator + parameters;
			var imgTag = document.createElement("img");
			imgTag.setAttribute("src", pixelUrl);
			document.body.appendChild(imgTag);
		}

		var fireTrackingPixel = function (userStatus, adBlockConvStatus) {
			if (userStatus == 'none') {
				// Something went wrong
				return
			}

			parameters = "abl=" + (userStatus == 'blocked' ? 1 : (userStatus == 'converted' ? 2 : 0));
			parameters += "&action=rxn_pageview";
			parameters += "&swidth=" + window.innerWidth;
			parameters += "&sheight=" + window.innerHeight;
			parameters += "&dt=" + getDeviceType();

			parameters += "&inb=" + (isNetworkBlocked ? 1 : 0);
			parameters += "&ibnia=" + (isBlockingNonIntrusiveAds ? 1 : 0);
			parameters += "&ibia=" + (isBlockingIntrusiveAds ? 1 : 0);


			// See if this user is a returning visitor
			if (getCookie(pageViewsCookieKey) !== '') {
				parameters += "&rv=1";
			}

			if (adBlockConvStatus === 'turned-on') {
				parameters += '&ton=1';
			} else if (adBlockConvStatus === 'turned-off') {
				parameters += '&toff=1';
			}

			fireAblPixel(parameters);
		};

		var fireReactionImpressionPixel = function (publicId, reactionType) {
			if (!publicId || !reactionType) {
				return;
			}

			var parameters = "action=rxn_impression";
			parameters += "&rpid=" + publicId;
			parameters += "&rt=" + reactionType;
			parameters += "&dt=" + getDeviceType();
			fireAblPixel(parameters);
		}

		var createTestAd = function () {

			// Intrusive ad
			var intrusiveAdNode = document.createElement("div");
			intrusiveAdNode.id = 'SponsoredLinks';
			var intrusiveTestStyle = 'pub_300x250 pub_300x250m pub_728x90 text-ad textAd text_ad text_ads text-ads text-ad-links';
			var intrusiveTestClass = 'width: 1px !important; height: 1px !important; position: absolute !important; left: -10000px !important; top: -1000px !important;';
			intrusiveAdNode.setAttribute('style', intrusiveTestStyle);
			intrusiveAdNode.setAttribute('class', intrusiveTestClass);
			window.document.body.appendChild(intrusiveAdNode);

			// Non-intrusive ad
			var nonIntrusiveAdNode = document.createElement("div");
			nonIntrusiveAdNode.id = 'influads_block';
			var testStyle = 'width: 2px !important; height: 2px !important; position: absolute !important;';
			nonIntrusiveAdNode.setAttribute('style', testStyle);
			window.document.body.appendChild(nonIntrusiveAdNode);

			// Networked blocked Ad
			var networkBlockedScriptTagInclude = document.createElement('script');
			var firstScriptNode = document.getElementsByTagName('script')[0];
			networkBlockedScriptTagInclude.onerror = function(msg) {
				isNetworkBlocked = 1;
			};
			networkBlockedScriptTagInclude.type = 'text/javascript';
			networkBlockedScriptTagInclude.async = true;
			networkBlockedScriptTagInclude.src = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'pagead2.googlesyndication.com/pagead/js/adsbygoogle.js';
			firstScriptNode.parentNode.insertBefore(networkBlockedScriptTagInclude, firstScriptNode)
		};

		var isAdBlockEnabled = function () {
			var isAdBlocked = false;

			var intrusiveAdDiv = window.document.getElementById('SponsoredLinks');
			var intrusiveAdVisibility = 'visible';
			var intrusiveAdWidth = 1;
			var intrusiveAdDisplay = 'none';
			if (intrusiveAdDiv !== undefined) {
				intrusiveAdDisplay = window.getComputedStyle(intrusiveAdDiv).getPropertyValue('display');
				intrusiveAdWidth = intrusiveAdDiv.offsetWidth;
			}
			intrusiveAdVisibility = window.getComputedStyle(intrusiveAdDiv).getPropertyValue('visibility');

			var nonIntrusiveAdDiv = window.document.getElementById('influads_block');
			var nonIntrusiveAdVisibility = 'visible';
			var nonIntrusiveAdWidth = 1;
			var nonIntrusiveAdDisplay = 'none';
			if (nonIntrusiveAdDiv !== undefined) {
				nonIntrusiveAdDisplay = window.getComputedStyle(nonIntrusiveAdDiv).getPropertyValue('display');
				nonIntrusiveAdWidth = nonIntrusiveAdDiv.offsetWidth;
			}
			nonIntrusiveAdVisibility = window.getComputedStyle(nonIntrusiveAdDiv).getPropertyValue('visibility');


			// Check if ad was removed.
			if (nonIntrusiveAdDisplay == 'none' || nonIntrusiveAdVisibility == 'hidden' || nonIntrusiveAdWidth == 0) {
				isAdBlocked = true;
				isBlockingNonIntrusiveAds = 1;
			}

			if (intrusiveAdDisplay == 'none' || intrusiveAdVisibility == 'hidden' || intrusiveAdWidth == 0) {
				isAdBlocked = true;
				isBlockingIntrusiveAds = 1;
			}

			return isAdBlocked;
		};

		var detectAdBlockers = function () {
			createTestAd();
			setTimeout(function () {
				var adBlockDetected = isAdBlockEnabled();
				var prevAdBlockStatus = getPreviousAdBlockStatus();
				var newAdBlockStatus = 'none';
				var convPixelStatus = 'none';

				if (adBlockDetected === true) {
					newAdBlockStatus = 'blocked';
					if (prevAdBlockStatus == 'not-blocked' || prevAdBlockStatus == 'converted') {
						convPixelStatus = 'turned-on';
					}
				} else if (adBlockDetected === false) {
					newAdBlockStatus = 'not-blocked';
					var reactionViews = getCookie(reactionViewsCookieKey);
					if (prevAdBlockStatus == 'blocked' && reactionViews !== '') {
						newAdBlockStatus = 'converted';
						convPixelStatus = 'turned-off';
					} else if (prevAdBlockStatus == 'converted') {
						newAdBlockStatus = 'converted';
					}
				}
				fireTrackingPixel(newAdBlockStatus, convPixelStatus);
				setAdBlockStatusCookie(newAdBlockStatus);
				incrementPageViews();
				incrementElapsedPageViews();
				trackPageViewsByDate();
				if (adBlockDetected === true) {
					react();
				}
				setVisitedStatus();
			}, 1000);
		};


		var setCookie = function(cname, cvalue, exdays) {
			var expires = "";
			if (exdays > 0) {
				var d = new Date();
				d.setTime(d.getTime() + (exdays*24*60*60*1000));
				expires = "expires="+d.toUTCString();
			}
			document.cookie = cname + "=" + cvalue + "; " + expires + "; path=/";
		};

		var getCookie = function(cname) {
			var name = cname + "=";
			var ca = document.cookie.split(';');
			for(var i=0; i<ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') c = c.substring(1);
				if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
			}
			return "";
		};

		var setAdBlockStatusCookie = function (status) {
			setCookie(adBlockStatusCookieKey, status, cookieExpiry);
		};

		var getPreviousAdBlockStatus = function() {
			var status = 'none';
			var prevAdBlockStatus = getCookie(adBlockStatusCookieKey);
			if (prevAdBlockStatus == 'true') {
				status = 'blocked';
			} else if (prevAdBlockStatus == 'false') {
				status = 'not-blocked'
			} else if (prevAdBlockStatus != '') {
				status = prevAdBlockStatus;
			}
			return status;
		};

		var incrementPageViews = function () {
			pageViews = getPageViews();
			pageViews += 1;
			setPageViews(pageViews);
		};

		var getPageViews = function () {
			var pageViews = getCookie(pageViewsCookieKey);
			if (pageViews === '') {
				pageViews = 0;
			}
			return Number(pageViews);
		};

		var setPageViews = function(pageViews) {
			setCookie(pageViewsCookieKey, pageViews, cookieExpiry);
		};

		var getElapsedPageViews = function() {
			var pageViews = getCookie(elapsedPageViewsCookieKey);
			if (pageViews === '') {
				pageViews = 0;
			}
			return Number(pageViews);
		};

		var resetElapsedPageViews = function() {
			setCookie(elapsedPageViewsCookieKey, 0, cookieExpiry);
		};

		var incrementElapsedPageViews = function () {
			pageViews = getElapsedPageViews();
			pageViews += 1;
			setCookie(elapsedPageViewsCookieKey, pageViews, cookieExpiry);
		};


		var setVisitedStatus = function() {
			var expires = "expires="+new Date().toUTCString().substr(0, 17)+'23:59:59 GMT';
			document.cookie = visitedBeforeCookieKey + "=" + 1 + "; " + expires + "; path=/";
		}

		var isUniqueVisitor = function() {
			var visited = getCookie(visitedBeforeCookieKey);
			if (visited == 1) {
				return false;
			}
			return true;
		}

		var incrementReactionViews = function (publicId) {
			var reactionViews = getCookie(reactionViewsCookieKey);
			if (reactionViews === '') {
				reactionViews = {};
				reactionViews[publicId] = 1;
			} else {
				reactionViews = JSON.parse(reactionViews);
				if (reactionViews.hasOwnProperty(publicId)) {
					reactionViews[publicId] = Number(reactionViews[publicId])+1;
				} else {
					reactionViews[publicId] = 1;
				}
			}
			setCookie(reactionViewsCookieKey, JSON.stringify(reactionViews), cookieExpiry);
		};

		var getReactionViews = function(publicId) {
			var reactionViews = getCookie(reactionViewsCookieKey);
			if (reactionViews === '') {
				return 0;
			} else {
				reactionViews = JSON.parse(reactionViews);
				if (reactionViews.hasOwnProperty(publicId)) {
					return Number(reactionViews[publicId]);
				} else {
					return 0;
				}
			}
		};

        var runReactionAndTracking = function(reactions, ruleId, publicId, reactionType) {
            if (reactions.hasOwnProperty('r'+publicId) && reactionType != '') {
                reactions['r'+publicId]();
                resetElapsedPageViews();
                fireReactionImpressionPixel(publicId, reactionType);
                incrementReactionViews(ruleId);
            }
        };

		var trackPageViewsByDate = function () {
			var d = new Date();
			var today = d.getFullYear().toString() + ((d.getMonth()+1) < 10 ? '0'+(d.getMonth()+1) : d.getMonth()+1).toString() + (d.getDate() < 10 ? '0'+d.getDate() : d.getDate()).toString();
			var pageViewsByDate = getCookie(pageViewsByDateCookieKey);
			if (pageViewsByDate === '') {
				// Cookie doen't exist.
				pageViewsByDate = {};
				pageViewsByDate[today] = 1;
			} else {
				pageViewsByDate = JSON.parse(pageViewsByDate);
				var len = pageViewsByDate.length-1;
				if (pageViewsByDate.hasOwnProperty(today)) {
					pageViewsByDate[today] = Number(pageViewsByDate[today])+1;
				} else {
					pageViewsByDate[today] = 1;
				}
			}
			// Truncate any dates greater than 31 days ago
			var dd = new Date();
			dd.setDate(d.getDate()-31);
			var delDate = dd.getFullYear().toString() + ((dd.getMonth()+1) < 10 ? '0'+(dd.getMonth()+1) : dd.getMonth()+1).toString() + (dd.getDate() < 10 ? '0'+dd.getDate() : dd.getDate()).toString();

			for (var key in pageViewsByDate) {
			  if (pageViewsByDate.hasOwnProperty(key) && Number(key) < Number(delDate)) {
				delete pageViewsByDate[key];
			  }
			}
			setCookie(pageViewsByDateCookieKey, JSON.stringify(pageViewsByDate), 31);
			return;
		};


		var getDeviceType = function() {
			var device = 'other';
			if (navigator.userAgent.match(/tablet|ipad|kft|bntv|playbook|touchpad/i)) {
				device = 'tablet';
			}
			else if (navigator.userAgent.match(/mobi|iphone|bb10|vita|symbian|blackberry|android|opera mini|netfront|dolfin|ovibrowser/i)) {
				device = 'mobile';
			}
			else if (navigator.userAgent.match(/x11.*cros/i)) {
				device = 'desktop';
			}
			else if (navigator.userAgent.match(/macintosh|windows|linux|valve source client|raptr/i)) {
				device = 'desktop';
			}
			return device;
		};

		var previewReaction = function(previewKey) {
			var url = 'https://www.muhammeddincer.com/wp-admin/admin-ajax.php';
			var searchSeparator = (url.indexOf('?') == -1) ? '?' : '&';
			var reaction = document.createElement('script'); reaction.type = 'text/javascript'; reaction.async = true;
			reaction.src = url + searchSeparator + 'action=rxn_preview&rxn_preview='+ previewKey;
			var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(reaction, s);
		}

		var getParamValue = function (param) {
			var vars = {};
			window.location.href.replace(
				/[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
				function( m, key, value ) { // callback
					vars[key] = value !== undefined ? value : '';
				}
			);

			if ( param ) {
				return vars[param] ? vars[param] : null;
			}
			return vars;
		}

		var checkWhitelist = function(urls)
		{
			var pass = false;
			if(typeof urls == "undefined" || urls.length == 0)
			{
				//no whitelist to check against
				pass = true;
			}
			else
			{
				for (i = 0; i < urls.length; i++) {
					if(testStringToCurrentUrl(urls[i]))
					{
						pass = true;
					}
				}
			}
			return pass;
		}

		var checkBlacklist = function(urls)
		{
			var pass = true;
			if(typeof urls !== "undefined" && urls.length !== 0)
			{
				for (i = 0; i < urls.length; i++) {
					if(testStringToCurrentUrl(urls[i]))
					{
						pass = false;
					}
				}
			}
			return pass;
		}

		var testStringToCurrentUrl = function(str)
		{
			current = window.location.href;
			str = str.replace("\\", "\\\\");
			str = str.replace(".", "\\.");
			str = str.replace("?", "\\?");
			str = str.replace("/", "\\/");
			str = str.replace("^", "\\^");
			str = str.replace("$", "\\$");
			str = str.replace("|", "\\|");
			str = str.replace("+", "\\+");
			str = str.replace("(", "\\(");
			str = str.replace(")", "\\)");
			str = str.replace("[", "\\[");
			str = str.replace("{", "\\{");
			str = str.replace("*", ".*");
			var re = new RegExp(str+"$");
			return re.test(current);
		}

		var react = function() {

            var deviceRegExp = new RegExp(getDeviceType(), 'i');
            var pageViews = getPageViews();
            var elapsedPageViews = getElapsedPageViews();
            var devices;
            var rules = [];
            var reactions = {};
                for (var i = 0; i < rules.length; i++) {
                    if (pageViews >= rules[i].pvTd &&
                        rules[i].ds.match(deviceRegExp) &&
                        checkWhitelist(rules[i].wu) &&
                        checkBlacklist(rules[i].bu) &&
						(rules[i].maxRV == 0 || getReactionViews(rules[i].pubId) < rules[i].maxRV)
					) {
						if (elapsedPageViews >= rules[i].pvF) {
                        	runReactionAndTracking(reactions, rules[i].pubId, rules[i].rxns[0].public_id, rules[i].rxns[0].type);
						}
                        return;
                    }
                }};


		var check = function () {
			// Process url params to see if we are in preview mode
            var previewKey = getParamValue("rxn_preview");
            if (previewKey) {
								previewReaction(previewKey);
				                return;
            }

			if (window.addEventListener !== undefined) {
				window.addEventListener('load', detectAdBlockers, false);
			} else {
				window.attachEvent('onload', detectAdBlockers);
			}
		};

		check();
	}
	var adBlocker = new Abx();
})();